unit Demo1;

interface

uses
  SysUtils,
  {$IFDEF Win32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Grids;

type
  TClipboardDemo = class(TForm)
    StringGrid1: TStringGrid;
    Panel1: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; aCol, aRow: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    Procedure UpdateClipboardDisplay (Sender: TObject);
  public
    { Public declarations }
  end;

var
  ClipboardDemo: TClipboardDemo;

implementation

{$R *.DFM}

Uses gClipBrd;

procedure TClipboardDemo.FormCreate(Sender: TObject);
begin
  Clipboard.OnChange := UpdateClipboardDisplay;
  StringGrid1.Cells [0, 0] := 'Size';
  StringGrid1.Cells [1, 0] := 'Name';
  UpdateClipboardDisplay (Sender);
end;

Procedure TClipboardDemo.UpdateClipboardDisplay (Sender: TObject);
var
  I:   Integer;
begin
  With Clipboard do begin
    Open;
    If HasFormat (cf_Text)
      Then Panel1.Caption := AsText
      Else Panel1.Caption := '';
    StringGrid1.RowCount := FormatCount + 1;
    For I := 0 to FormatCount - 1 do begin
      StringGrid1.Cells [0, I + 1] := IntToHex (GlobalSize (GetAsHandle (Formats[I])),5);
      StringGrid1.Cells [1, I + 1] := FormatNames [I];
      end;
    Close;
    end;
  end;

procedure TClipboardDemo.StringGrid1DrawCell(Sender: TObject; aCol,
  aRow: Longint; Rect: TRect; State: TGridDrawState);
begin
  With StringGrid1 do begin
    If aRow < FixedRows
      Then Canvas.Brush.Color := clBtnFace
      Else Canvas.Brush.Color := Color;
    Canvas.FillRect (Rect);
    Case aCol of
      0:
        Canvas.Textout (Rect.Right - Canvas.TextWidth (Cells[aCol, aRow]) - 4,
                        Rect.Top, Cells [aCol, aRow]);
      1:
        Canvas.Textout (Rect.Left + 2, Rect.Top, Cells [aCol, aRow]);
      end;
    end;
  end;

procedure TClipboardDemo.FormResize(Sender: TObject);
begin
  With StringGrid1 do
    ColWidths[1] := ClientWidth - ColWidths [0];
end;

end.
